
#引用
library(survival)
library(survminer)
inputFile="m6Ascore.txt"        
outFile="m6Ascore.pdf"      
var="Risk"                  
setwd("D:\\BaiduSyncdisk\\辅助生信\\READ\\铜死亡\\2.Model")     


rt=read.table(inputFile, header=T, sep="\t", check.names=F)
rt=rt[,c("futime","fustat",var)]

#根据中位值，把样品分为两组
group=ifelse(rt[,3]>median(rt[,3]),"High","Low")
diff=survdiff(Surv(futime, fustat) ~group,data = rt)
pValue=1-pchisq(diff$chisq,df=1)
if(pValue<0.001){
	pValue="p<0.001"
}else{
	pValue=paste0("p=",sprintf("%.03f",pValue))
}
fit <- survfit(Surv(futime, fustat) ~ group, data = rt) #剩余数目
		
#绘制
surPlot=ggsurvplot(fit, 
		           data=rt,
		           conf.int=TRUE,
		           pval=pValue,
		           pval.size=5,
		           legend.labs=c("High", "Low"),
		           legend.title=var,
		           xlab="Time(years)",
		           break.time.by = 1,
		           risk.table.title="",
		           palette=c("#FB8072","#80B1D3"),
		           risk.table=T,
		           risk.table.height=.25)
pdf(file=outFile,onefile = FALSE,width = 6,height =5)
print(surPlot)
dev.off()
